import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;

/**
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Benutzerschnittstelle extends JFrame
{
    // Satische vordefinierteFarben
    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;
    private static final Color FELD_STANDART_HINTERGRUND = Color.white;
    private static final Color FELD_VERAENDERT_HINTERGRUND = Color.lightGray;
    private static final Color FELD_AKTUELLES_FELD = Color.yellow;
    private static final Color PRUEFEN_BUTTON_RICHTIG = Color.green;
    private static final Color PRUEFEN_BUTTON_FALSCH = Color.red;
    private Color aktuelleHintergrundfarbe;

    private Steuerung steuerung;
    
    private JButton pruefen;

    private HashMap <JButton, Integer> hashMapButtonBenutzereingabe;
    private JButton [] [] spielfeldMitAllenKnoepfen;
    private HashSet<JButton> benutzereingabe;
    private JMenuBar menuBar;

    public Benutzerschnittstelle(Steuerung pSteuerung)
    {
        this.steuerung = pSteuerung;
        erstelleBildschirm(); 

    }

    //Methoden von den ActionListenern aufgerufen
    private void ladeSudokuBefehl(int pNummer)
    {
        steuerung.ladeSudoku(new Integer(pNummer));
        refresh();
    }

    private void hellerBefehl()
    {
        aktuelleHintergrundfarbe = FELD_STANDART_HINTERGRUND;
        felderAktualisieren();
    }

    private void dunklerBefehl()
    {
        aktuelleHintergrundfarbe = FELD_VERAENDERT_HINTERGRUND;
        felderAktualisieren();
    }

    private void zeigeVersionBefehl()
    {
        JOptionPane.showMessageDialog(null, 
            "Sudoku\n" + steuerung.gibVersion(),
            "Info zu Sudoku", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    private void zeigeAnleitungBefehl()
    {
        JOptionPane.showMessageDialog(null, 
            "Spielanleitung: Waehl dir links ein Sudoku.\n Dann kannst du ein Feld mit der Maus auswaehlen und eine Zahl eingeben.\n Mit pruefen kannst du sehen, ob du richtig bist. gruen = richtig. rot = falsch",
            "", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    private void beendenBefehl()
    {
        System.exit(0);
    }

    private void pruefenBefehl()
    {
        if (steuerung.istSudokuInitialisiert() == true)
        {
            boolean tmp = steuerung.testeObSudokuKorrektIst();
            if (tmp)
            {
                pruefen.setBackground (Color.green);
            }
            else
            {
                pruefen.setBackground (Color.red);
            }
        }
        felderAktualisieren();
    }

    /**
     * Die Buttons von den Sudoku Feldern waehlen das aktuelle Feld 
     */
    private void benutzerEingabeFeldWirdAlsAktuellesFeldGewaehltBefehl(int pWertX, int pWertY)
    {
        if ((pWertX >= 0 && pWertX < 9) && (pWertY >= 0 && pWertY < 9))
        {
            steuerung.setzeAktuellesFeld(pWertX, pWertY);
            felderAktualisieren();
        }
    }

    private void benutzerEingabeZahlWirdAufFeldAngewendet(int pWert)
    {
        if (pWert >= 0 && pWert <= 9 && steuerung.hatSudokuAktuellesFeld())
        {
            steuerung.setzteZahlAktuellesFeld(pWert);
            felderAktualisieren();
        }
    }
    
    //Hilfsmethoden

    private void refresh()
    {
        this.getContentPane().removeAll();
        this.erstelleContentPane();
    }
    
    private void zeigeSpielGewonnenBefehl()
    {
        JOptionPane.showMessageDialog(null, 
            "Du hast Gewonnen",
            "", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    // BildschirmkomponenteErzeugen

    private void erstelleBildschirm()
    {
        this.setName("Sudoku");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLayout(null);

        erstelleMenue();
        erstelleContentPane();

        // Das Fenster in der Mitte des Bildschirms platzieren und anzeigen
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width/2 - this.getWidth()/2, d.height/2 - this.getHeight()/2);
        this.setVisible(true);
    }

    private void erstelleMenue()
    {
        menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);

        JMenu menuSudokuAuswahl = new JMenu("Sodoku");
        menuBar.add(menuSudokuAuswahl);

        HashMap <JMenuItem, Integer> sudokuUndSudokuNummer = new HashMap <JMenuItem, Integer>();
        int sudokuMenuAuswahlNummer = 1;
        while (sudokuMenuAuswahlNummer <= steuerung.gibAnzahlGespeicherterSudokus())
        {
            JMenuItem sudokuMenuItem = new JMenuItem("Sudoku " + sudokuMenuAuswahlNummer);
            sudokuUndSudokuNummer.put(sudokuMenuItem, new Integer(sudokuMenuAuswahlNummer));

            sudokuMenuItem.addActionListener(new ActionListener() {
                    @Override public void actionPerformed(ActionEvent e) {

                        ladeSudokuBefehl(sudokuUndSudokuNummer.get((JMenuItem) e.getSource()).intValue());
                    }
                });
            menuSudokuAuswahl.add(sudokuMenuItem);

            sudokuMenuAuswahlNummer ++;
        }

        menuSudokuAuswahl.addSeparator();

        JMenuItem beendenMenuItem = new JMenuItem("Beenden");
        beendenMenuItem.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    beendenBefehl();
                }
            });
        menuSudokuAuswahl.add(beendenMenuItem);

        JMenu menuHelligkeit = new JMenu("Helligkeit");
        menuBar.add(menuHelligkeit);

        JMenuItem menuItemHeller = new JMenuItem("Heller");
        menuHelligkeit.add(menuItemHeller);
        menuItemHeller.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    hellerBefehl();
                }
            });

        JMenuItem menuItemDunkler = new JMenuItem("Dunkler");
        menuHelligkeit.add(menuItemDunkler);
        menuItemDunkler.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    dunklerBefehl();
                }
            });

        JMenu menuHilfe = new JMenu("Hilfe");
        menuBar.add(menuHilfe);

        JMenuItem menuItemEintrag1 = new JMenuItem("Anleitung");
        menuHilfe.add(menuItemEintrag1);
        menuItemEintrag1.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    zeigeAnleitungBefehl();
                }
            });

        JMenuItem menuItemVersion = new JMenuItem("Version");
        menuHilfe.add(menuItemVersion);
        menuItemVersion.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    zeigeVersionBefehl();
                }
            });
    }

    private void erstelleContentPane()
    {
        JPanel contentPane = (JPanel) this.getContentPane();
        contentPane.setBorder(new EmptyBorder(6, 6, 6, 6));
        contentPane.setLayout(new BorderLayout(6, 6));

        erstelleNorth();

        erstelleWest();
        
        erstelleCenter();
    }
    
    private void erstelleNorth()
    {
        JPanel panelNorth = new JPanel();
        this.getContentPane().add(panelNorth, BorderLayout.NORTH);  
        
        pruefen = new JButton("Pruefen");
        panelNorth.add(pruefen);
        pruefen.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    pruefenBefehl();
                }
            });
        pruefen.setBackground(Color.green);
    }
    
    private void erstelleWest()
    {
        JPanel panelWest = new JPanel();
        this.getContentPane().add(panelWest, BorderLayout.WEST);
        panelWest.setLayout(new FlowLayout());
        
        JPanel panelBenutzereingaben = new JPanel();
        panelWest.add(panelBenutzereingaben);
        panelBenutzereingaben.setLayout(new GridLayout(0, 2));
        
        benutzereingabe = new HashSet<JButton> ();
        hashMapButtonBenutzereingabe = new HashMap <JButton, Integer> ();

        for (int i = 0; i < 10; i++)
        {
            JButton tmp = new JButton("     " + i + "     ");
            panelBenutzereingaben.add(tmp);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i)); 
            tmp.addActionListener(new ActionListener() {
                    @Override public void actionPerformed(ActionEvent e) {
                        benutzerEingabeZahlWirdAufFeldAngewendet(hashMapButtonBenutzereingabe.get((JButton) e.getSource()).intValue());
                    }
                });
            tmp.setBackground(new Color(0, 0, 100));
            tmp.setForeground(new Color(255, 150, 130));
        }

        
    }
    
    private void erstelleCenter()
    {
        JPanel panelCenter = new JPanel();
        this.getContentPane().add(panelCenter, BorderLayout.CENTER);
        panelCenter.setLayout(null);
        
        erzeugeDasSpielfeld(panelCenter);
    }

    private void erzeugeDasSpielfeld(JPanel pPanelSpielfeld)
    {
        if (steuerung.istSudokuInitialisiert() == false)
        {
            return;
        }
        spielfeldMitAllenKnoepfen = null;
        spielfeldMitAllenKnoepfen = new JButton [steuerung.gibSeitenLaengeVonSudoku()]  [steuerung.gibSeitenLaengeVonSudoku()];
        int yKoordinateSudokuButtons = 0;
        int xKoordinateSudokuButtons = 0;

        int sudokuBlock3 = 10;
        HashMap <JButton, Integer> jButtonFeldXKoordinaten = new HashMap <JButton, Integer>();
        HashMap <JButton, Integer> jButtonFeldYKoordinaten = new HashMap <JButton, Integer>();

        while (yKoordinateSudokuButtons < steuerung.gibSeitenLaengeVonSudoku())
        {
            xKoordinateSudokuButtons = 0;
            int sudokuBlock3RelativIntY = yKoordinateSudokuButtons / 3;
            while (xKoordinateSudokuButtons < steuerung.gibSeitenLaengeVonSudoku())
            {
                JButton tmp = new JButton ("x=" + xKoordinateSudokuButtons+1 + "   y=" + yKoordinateSudokuButtons+1);
                spielfeldMitAllenKnoepfen [yKoordinateSudokuButtons] [xKoordinateSudokuButtons] =  tmp;

                int sudokuBlock3RelativIntX = xKoordinateSudokuButtons / 3;

                tmp.setBounds((sudokuBlock3 * sudokuBlock3RelativIntX) + ((xKoordinateSudokuButtons + 1) * 52),(sudokuBlock3 * sudokuBlock3RelativIntY) + ((yKoordinateSudokuButtons + 1) * 52), 50, 50);

                if (steuerung.istFeldVeraenderbar(xKoordinateSudokuButtons, yKoordinateSudokuButtons) == true)
                {
                    tmp.setForeground(FELD_VERAENDERBAR);
                }
                else
                {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }

                pPanelSpielfeld.add(tmp);

                jButtonFeldXKoordinaten.put(tmp, new Integer(xKoordinateSudokuButtons));
                jButtonFeldYKoordinaten.put(tmp, new Integer(yKoordinateSudokuButtons));

                tmp.addActionListener(new ActionListener() {
                        @Override public void actionPerformed(ActionEvent e) {
                            benutzerEingabeFeldWirdAlsAktuellesFeldGewaehltBefehl(jButtonFeldXKoordinaten.get(((JButton) e.getSource())).intValue(), jButtonFeldYKoordinaten.get(((JButton) e.getSource())).intValue());
                        }
                    });

                xKoordinateSudokuButtons ++;

            }
            yKoordinateSudokuButtons ++;

        }
        hellerBefehl();
        felderAktualisieren();
    }

    private void felderAktualisieren()
    {        
        if (steuerung.istSudokuInitialisiert() == true)
        {
            int xKoordinateSudokuButtons = 0;
            int yKoordinateSudokuButtons = 0;  

            while (yKoordinateSudokuButtons < steuerung.gibSeitenLaengeVonSudoku())
            {
                xKoordinateSudokuButtons = 0;
                while (xKoordinateSudokuButtons < steuerung.gibSeitenLaengeVonSudoku())
                {
                    JButton tmp = null;
                    tmp = spielfeldMitAllenKnoepfen [yKoordinateSudokuButtons] [xKoordinateSudokuButtons];

                    if (steuerung.getZahlFeld (xKoordinateSudokuButtons, yKoordinateSudokuButtons) == 0)
                    {
                        tmp.setText("");
                    }
                    else if (steuerung.getZahlFeld (xKoordinateSudokuButtons, yKoordinateSudokuButtons) >= 1 && steuerung.getZahlFeld (xKoordinateSudokuButtons, yKoordinateSudokuButtons) <= 9)
                    {
                        tmp.setText("" + steuerung.getZahlFeld (xKoordinateSudokuButtons, yKoordinateSudokuButtons));
                    }
                    else
                    {
                        System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                    }

                    tmp.setBackground (aktuelleHintergrundfarbe);

                    if (steuerung.istAktuellesFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons))
                    {
                        tmp.setBackground(FELD_AKTUELLES_FELD);
                    }

                    xKoordinateSudokuButtons ++;
                }
                yKoordinateSudokuButtons ++;
            }

            if (steuerung.spielIstGewonnen() ==  true)
            {
                zeigeSpielGewonnenBefehl();
            }
        }

    }

}